/* 
 *      XAB 1.0
 *
 *		Adam Beguelin
 *      University of Tennesee, Knoxville, TN.
 *      Oak Ridge National Laboratory, Oak Ridge, TN.
 *      26 Nov 1991
 *
 *      xab.h
 *		
 *		User include file for xab
 *
 * These macros should be included when the xab tool is to be
 * used to visualize what is happening in a pvm program.
 *
 */

/***********************
* Crunch related calls *
***********************/

#define initsend() 			xab_initsend()

#define putnint(np, cnt)	xab_putnint(np, cnt)
#define getnint(np, cnt)	xab_getnint(np, cnt)

#define putnshort(np, cnt)	xab_putnshort(np, cnt)
#define getnshort(np, cnt)	xab_getnshort(np, cnt)

#define putnlong(np, cnt)	xab_putnlong(np, cnt)
#define getnlong(np, cnt)	xab_getnlong(np, cnt)

#define putnfloat(np, cnt)	xab_putnfloat(np, cnt)
#define getnfloat(np, cnt)	xab_getnfloat(np, cnt)

#define putndfloat(np, cnt)	xab_putndfloat(np, cnt)
#define getndfloat(np, cnt)	xab_getndfloat(np, cnt)

#define putncplx(np, cnt)	xab_putncplx(np, cnt)
#define getncplx(np, cnt)	xab_getncplx(np, cnt)

#define putbytes(np, cnt)	xab_putbytes(np, cnt)
#define getbytes(np, cnt)	xab_getbytes(np, cnt)

#define putstring(cp)		xab_putstring(cp)
#define getstring(cp)		xab_getstring(cp)


/*********************
* User Library Calls *
*********************/

#define barrier(name, num)				xab_barrier(name, num)
#define enroll(proc)					xab_enroll(proc)
#define initiate(aout, arch)			xab_initiate(aout, arch)
#define initiateM(aout, host)			xab_initiateM(aout, host)
#define leave()							xab_leave()
#define probe(type)						xab_probe(type)
#define pstatus(nproc, mixed)			xab_pstatus(nproc, mixed)
#define rcv(type)						xab_rcv(type)
#define vrcv(type)						xab_vrcv(type)
#define rcvmulti(ntypes, types) 		xab_rcvmulti(ntypes, types)
#define rcvinfo(len, type, proc, inum)	xab_rcvinfo(len, type, proc, inum)
#define ready(event)					xab_ready(event)
#define snd(proc, inum, type)			xab_snd(proc, inum, type)
#define vsnd(proc, inum, type)			xab_vsnd(proc, inum, type)
#define status(proc, inum)				xab_status(proc, inum)
#define terminate(proc, inum)			xab_terminate(proc, inum)
#define waituntil(event)				xab_waituntil(event)
#define whoami(proc, inum)				xab_whoami(proc, inum)

